% Generated by roxygen2 (4.1.0): do not edit by hand
% Please edit documentation in R/gsw.R
\name{gsw_alpha_on_beta}
\alias{gsw_alpha_on_beta}
\title{Thermal expansion coefficient over haline contraction coefficient (48-term equation)}
\usage{
gsw_alpha_on_beta(SA, CT, p)
}
\arguments{
\item{SA}{Absolute Salinity [ g/kg ]}

\item{CT}{Conservative Temperature [ deg C ]}

\item{p}{sea pressure [ dbar ]}
}
\value{
ratio of thermal expansion coefficient to haline contraction coefficient [ (g/kg)/K ]
}
\description{
Thermal expansion coefficient over haline contraction coefficient (48-term equation)
}
\examples{
gsw_alpha_on_beta(34.7118, 28.8099, 10) # 0.452454540612631
}
\references{
\url{http://www.teos-10.org/pubs/gsw/html/gsw_alpha_on_beta.html}
}
\seealso{
This yields the ratio of the return values from \code{\link{gsw_alpha}} and \code{\link{gsw_beta}}, to within computational precision.
}

