% Generated by roxygen2 (4.0.1): do not edit by hand
\name{migrate}
\alias{migrate}
\title{This function returns a data frame that has moved migrants}
\usage{
migrate(data, stratum = "Population", m = 0.1, relabel = TRUE)
}
\arguments{
\item{data}{A \code{data.frame} object with at least a stratum
column.  All other columns in the data frame are left untouched}

\item{stratum}{The column designating stratum.}

\item{m}{Either a rate of migration as a numeric OR a migration
matrix whose columns and row names are the same as those in the
passed stratum column.}

\item{relabel}{A flag (default TRUE) that relabels individuals after
they have been moved between populations.  Used for testing only.}
}
\value{
A \code{data.frame} with all the data the same except for
 the shuffled stratum.
}
\description{
This is a general function that moves migrants among strata
 according to either a constant migration rate or a
 set of migration rates defined by a migration matrix. All
 this does is adjust the stratum labels of individuals,
 no mating is conducted.
}
\note{
This is a simple transition matrix approach to migration.  The
 migration rate times the population size MUST result in at least
 a whole number or else no migrants are produced.  It uses \code{round()}
 to find the whole number of individuals to migrate.  This means that
 if you have a migration rate that has less than one individual it
 will NEVER occur, not that it will occur at a less than one individual
 per generation frequency.  You must adjust your migration rates
 directly for that (e.g., the user has the entire power, not the
 this function).
}
\author{
Rodney J. Dyer \email{rjdyer@vcu.edu}
}

