% Generated by roxygen2 (4.0.1): do not edit by hand
\name{frequencies}
\alias{frequencies}
\alias{frequencies.data.frame}
\alias{frequencies.default}
\alias{frequencies.locus}
\title{Get allele frequencies}
\usage{
frequencies(x, loci, stratum, ...)

\method{frequencies}{default}(x, ...)

\method{frequencies}{locus}(x, loci, ...)

\method{frequencies}{data.frame}(x, loci, stratum, ...)
}
\arguments{
\item{x}{Either a vector of types \code{locus} or a \code{data.frame}
containing \code{locus} objects.}

\item{loci}{The loci to get frquencies from (default is all).}

\item{stratum}{Partition of the data based upon this stratum
(default is no partitions).}

\item{...}{Ignored}
}
\value{
A data frame with Frequencies, Alleles, Loci, and perhaps
 Stratum columns (Allele and Frquencies are at a minimium).

A data frame with Frequencies, Alleles, Loci, and perhaps
 Stratum columns (Allele and Frquencies are at a minimium).

A data frame with Frequencies, Alleles, Loci, and perhaps
 Stratum columns (Allele and Frquencies are at a minimium).

A data frame with Frequencies, Alleles, Loci, and perhaps
 Stratum columns (Allele and Frquencies are at a minimium).
}
\description{
This function converts loci into data frames consisting of
 alleles, stratum, frequencies, etc.
}
\note{
You can submit RAD-seq genotypes in a normal \code{data.frame}
 to this function BUT it must be formatted as follows.  Each locus
 is represented by three columns of probabilities (must sum to 1).
 You must label the columns of your data frame with the name of the locus
 and a column number separated by an underscore '_' (e.g., Loc1_1, Loc1_2,
 Loc1_3, Loc2_1, Loc2_2, Loc2_3, etc).  The function will name the locus
 the part before the dash (e.g., Loc1). The frequencies of the heterozygote
 genotype frequency represented in the middle position.
}
\examples{
AA <- locus( c("A","A") )
AB <- locus( c("A","B") )
BB <- locus( c("B","B") )
loc1 <- c(AA,AB,AB,AA,BB)
frequencies(loc1)
loc2 <- c(BB,BB,AB,AA,BB)
df <- data.frame(Population=c(rep("A",3), rep("B",2)), TPI=loc1, PGM=loc2)
frequencies(df)
frequencies(df,stratum="Population")
# RAD-seq example
m <- matrix(abs(rnorm(30)),nrow=10)
m <- m / rowSums(m)
df <- data.frame(m)
names(df) <- c("Loc1_1","Loc1_2","Loc1_3")
frequencies(df)
}
\author{
Rodney J. Dyer \email{rjdyer@vcu.edu}
}

