% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.R
\name{plot_samp}
\alias{plot_samp}
\title{Plot all chromosomes of a sample}
\usage{
plot_samp(dat, samp, ncol = NULL, delthresh = NULL, dupthresh = NULL, ...)
}
\arguments{
\item{dat}{List object, containing at least two matrices "baf" and "rratio"
and two vectors "chr" and "pos".}

\item{samp}{Integer, which sample should be plotted.}

\item{ncol}{Integer, number of colors.}

\item{delthresh}{Numeric, lower threshold for intensities.}

\item{dupthresh}{Numeric, upper threshold for intensities.}

\item{...}{arguments are forwarded to \code{plot()}.}
}
\description{
Plot all chromosomes of a sample
}
\examples{
if(require(brassicaData)){
data("raw_napus", package = "brassicaData", envir = environment())
\dontshow{
raw_napus <- filt_samp(raw_napus, raw_napus$samples[-(1:10)])
raw_napus <- filt_snps(raw_napus, raw_napus$snps[-(1:100)][-(30000:30100)])
}
dat <- intens_theta(raw_napus)
dat <- remove_suffix(dat, "_Grn")
dat <- geno_baf_rratio(dat, delthresh = 11)
plot_samp(dat, 1)
}
}

