% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/nls-methods.R
\name{logLik.gsl_nls}
\alias{logLik.gsl_nls}
\title{Extract model log-likelihood}
\usage{
\method{logLik}{gsl_nls}(object, REML = FALSE, ...)
}
\arguments{
\item{object}{An object inheriting from class \code{"gsl_nls"}.}

\item{REML}{logical value; included for compatibility reasons only, should not be used.}

\item{...}{At present no optional arguments are used.}
}
\value{
Numeric object of class \code{"logLik"} identical to \code{\link[stats]{logLik}}.
}
\description{
Returns the model log-likelihood of a fitted \code{"gsl_nls"} object.
}
\examples{
## data
set.seed(1)
x <- 1:10
y <- 1 + 0.5 * (1:10) + rnorm(10, sd = 0.1)
## model
obj <- gsl_nls(fn = y ~ a + b * x, data = data.frame(x = x, y = y), start = c(a = 0, b = 1))
logLik(obj)
}
\seealso{
\code{\link[stats]{logLik}}
}
