% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/signals.R
\docType{data}
\name{signals}
\alias{signals}
\title{signals}
\format{
A \code{\link{data.frame}} containing 10 seconds of data
  electrophysiological data, sampled at 256 Hz with a 24 bit A/D converter,
  measured in microVolts. The data frame consists of 2 columns (channels):
\describe{
  \item{eeg}{electroencephalogram (EEG) data measured from electrode Pz
  according to the 10-20 system, referred to algebraically linked mastoids
  (the brain's alpha rhythm is clearly visible).}
  \item{ecg}{electrocardiogram (ECG) data, recorded bipolarly with a V6
  versus V1 chest lead (this lead maximizes the R wave of the ECG with
  respect to the P, Q, S, T and U waves of the cardiac cycle).}
}
}
\usage{
signals
}
\description{
Sample EEG and ECG data.
}
\examples{
data(signals)
time <- seq(0, 10, length.out = nrow(signals))
op <- par(mfcol = c(2, 1))
plot(time, signals[, 1], type = "l", xlab = "Time", ylab = "EEG (uV)")
plot(time, signals[, 2], type = "l", xlab = "Time", ylab = "ECG (uV)")
par(op)

}
\author{
Geert van Boxtel, \email{G.J.M.vanBoxtel@gmail.com}
}
\keyword{datasets}
