% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/conv.R
\name{conv}
\alias{conv}
\title{Convolution and polynomial multiplication}
\usage{
conv(a, b, shape = c("full", "same", "valid"))
}
\arguments{
\item{a, b}{Input, coerced to vectors, can be different lengths or data types.}

\item{shape}{Subsection of convolution, partially matched to \code{"full"}
(full convolution - default), \code{"same"} (central part of the
convolution of the same size as \code{a}), or \code{"valid"} (only those
parts of the convolution that are computed without the zero-padded edges)}
}
\value{
Output vector with length equal to \code{length (a) + length (b) -
  1}. When the parameter \code{shape} is set to \code{"valid"}, the length of
  the output is \code{max(length(a) - length(b) + 1, 0)}, except when
  length(b) is zero. In that case, the length of the output vector equals
  \code{length(a)}.

  When \code{a} and \code{b} are the coefficient vectors of two polynomials,
  the convolution represents the coefficient vector of the product
  polynomial.
}
\description{
Convolve two vectors \code{a} and \code{b}.
}
\details{
The convolution of two vectors, \code{a} and \code{b}, represents the area of
overlap under the points as \code{B} slides across \code{a}. Algebraically,
convolution is the same operation as multiplying polynomials whose
coefficients are the elements of \code{a} and \code{b}.

The function \code{conv} uses the \code{\link{filter}} function, NOT
\code{fft}, which may be faster for large vectors.
}
\examples{
u <- rep(1L, 3)
v <- c(1, 1, 0, 0, 0, 1, 1)
w <- conv(u, v)

## Create vectors u and v containing the coefficients of the polynomials
## x^2 + 1 and 2x + 7.
u <- c(1, 0, 1)
v <- c(2, 7)
## Use convolution to multiply the polynomials.
w <- conv(u, v)
## w contains the polynomial coefficients for 2x^3 + 7x^2 + 2x + 7.

## Central part of convolution
u <- c(-1, 2, 3, -2, 0, 1, 2)
v <- c(2, 4, -1, 1)
w <- conv(u, v, 'same')

}
\author{
Tony Richardson, \email{arichard@stark.cc.oh.us}, adapted by John W.
  Eaton.\cr Conversion to R by Geert van Boxtel,
  \email{G.J.M.vanBoxtel@gmail.com}.
}
