% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/aryule.R
\name{aryule}
\alias{aryule}
\title{Autoregressive model coefficients - Yule-Walker method}
\usage{
aryule(x, p)
}
\arguments{
\item{x}{input data, specified as a numeric or complex vector or matrix. In
case of a vector it represents a single signal; in case of a matrix each
column is a signal.}

\item{p}{model order; number of poles in the AR model or limit to the number
of poles if a valid criterion is provided. Must be smaller than the length
of \code{x} minus 1.}
}
\value{
A \code{list} containing the following elements:
  \describe{
    \item{a}{vector or matrix containing \code{(p + 1)} autoregression
    coefficients. If \code{x} is a matrix, then each row of a corresponds to
    a column of \code{x}. \code{a} has \code{p + 1} columns.}
    \item{e}{white noise input variance, returned as a vector. If \code{x} is
    a matrix, then each element of e corresponds to a column of \code{x}.}
    \item{k}{Reflection coefficients defining the lattice-filter embodiment
    of the model returned as vector or a matrix. If \code{x} is a matrix,
    then each column of \code{k} corresponds to a column of \code{x}.
    \code{k} has \code{p} rows.}
  }
}
\description{
compute autoregressive all-pole model parameters using the Yule-Walker
method.
}
\details{
\code{aryule} uses the Levinson-Durbin recursion on the biased estimate of
the sample autocorrelation sequence to compute the parameters.
}
\note{
The power spectrum of the resulting filter can be plotted with
  \code{pyulear(x, p)}, or you can plot it directly with
  \code{ar_psd(a,v,...)}.
}
\examples{
a <- Arma(1, c(1, -2.7607, 3.8106, -2.6535, 0.9238))
y <- filter(a, rnorm(1024))
coefs <- aryule(y, 4)

}
\seealso{
\code{\link{ar_psd}}, \code{\link{arburg}}
}
\author{
Paul Kienzle, \email{pkienzle@users.sf.net},\cr
 Peter V. Lanspeary, \email{pvl@mecheng.adelaide.edu.au}.\cr
 Conversion to R by Geert van Boxtel, \email{gjmvanboxtel@gmail.com}.
}
