% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/construct_download_url.R
\name{construct_download_url}
\alias{construct_download_url}
\title{Construct a google sheet download url from the sheet's viewing url}
\usage{
construct_download_url(url, format = "csv", sheetid = NULL)
}
\arguments{
\item{url}{the google sheet url}

\item{format}{controls the column separator used. \code{csv} or \code{tsv}}

\item{sheetid}{the id of the sheet to download from.  (Default \code{NULL}, downloads the first sheet)}
}
\description{
Converts the viewing url for a google sheet to a download url.
}
\examples{

# Download a sheet manually using readr
url <- 'docs.google.com/spreadsheets/d/1I9mJsS5QnXF2TNNntTy-HrcdHmIF9wJ8ONYvEJTXSNo'

if(requireNamespace('readr', quietly=TRUE)){
  library(readr)
  read_csv(construct_download_url(url), col_types = cols(
    mpg = col_double(),
    cyl = col_integer(),
    disp = col_double(),
    hp = col_integer(),
    drat = col_double(),
    wt = col_double(),
    qsec = col_double(),
    vs = col_integer(),
    am = col_integer(),
    gear = col_integer(),
    carb = col_integer()
  ))
}

}
