% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/information.R
\name{get_info_gsnb}
\alias{get_info_gsnb}
\title{Information level for log rate ratio}
\usage{
get_info_gsnb(rate1, rate2, dispersion, followup1, followup2)
}
\arguments{
\item{rate1}{numeric; rate in treatment group 1}

\item{rate2}{numeric; rate in treatment group 2}

\item{dispersion}{numeric; dispersion (shape) parameter of negative binomial distribution}

\item{followup1}{numeric vector; individual follow-up times in treatment group 1}

\item{followup2}{numeric vector; individual follow-up times in treatment group 2}
}
\value{
numeric; information level
}
\description{
Calculates the information level for the log rate ratio of
the negative binomial model
}
\examples{
# Calculates information level for case of 10 subjects per group
# Follow-up times of subjects in each group range from 1 to 3
get_info_gsnb(rate1 = 0.1,
              rate2 = 0.125,
              dispersion = 4, 
              followup1 = seq(1, 3, length.out = 10), 
              followup2 = seq(1, 3, length.out = 10))
}
