% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/op_fwer_cont.R
\name{op_fwer_cont}
\alias{op_fwer_cont}
\title{Provides operating characteristics of group sequential MAMS trial for continuous outcome under null hypothesis}
\usage{
op_fwer_cont(alpha, beta, K, frac, delta0, delta1, nsim, seed)
}
\arguments{
\item{alpha}{Type I error.}

\item{beta}{Type II error.}

\item{K}{Number of treatment arms.}

\item{frac}{Vector of fractions for information time at each look.}

\item{delta0}{Standardized effect size in ineffective arm.}

\item{delta1}{Standardized effect size in effective arm.}

\item{nsim}{Number of simulations.}

\item{seed}{Random seed number.}
}
\value{
A list of FWER, stage-wise type I error, average sample size used per arm, stopping probability, probability of futility.
}
\description{
Computes FWER and other characteristics for group-sequential MAMS trial for continuous outcome.
}
\examples{
op_fwer_cont(0.05,0.1,2,c(0.5,1),0.178,0.545,15,1)
}
