% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/prox.R
\name{prox_sorted_L1}
\alias{prox_sorted_L1}
\title{Prox for sorted L1 norm}
\usage{
prox_sorted_L1(x, lambda, method = c("c", "isotone"))
}
\arguments{
\item{x}{input vector}

\item{lambda}{vector of \eqn{\lambda}'s, sorted in decreasing order}

\item{method}{underlying prox implementation, either 'c' or 'isotone'
(see Details)}
}
\description{
Compute the prox for the sorted L1 norm. That is, given a vector \eqn{x}
and a decreasing vector \eqn{\lambda}, compute the unique value of \eqn{y}
minimizing
\deqn{\frac{1}{2} \Vert x - y \Vert_2^2 +
      \sum_{i=1}^n \lambda_i |x|_{(i)}.}
At present, two methods for computing the sorted L1 prox are
supported. By default, we use a fast custom C implementation. Since SLOPE
can be viewed as an isotonic regression problem, the prox can also be
computed using the \code{isotone} package. This option is provided
primarily for testing.
}
\details{
This function has been adapted (with only cosmetic changes) from
the R package \code{SLOPE} version 0.1.3, due to this function being
deprecated and defunct in \code{SLOPE} versions which are newer than 0.1.3.
}
