# This file was generated by Rcpp::compileAttributes
# Generator token: 10BE3573-1514-4C36-9D1C-5A225CD40393

#' Monte Carlo based adjustment of the SLOPE tuning parameters
#'
#' \code{lambdaMC} adjusts the SLOPE regularizing sequence for correlations in 
#'    the data via a Monte Carlo approach which assumes normality of the error terms.
#'
#' @param lambda_BH The regualrizing sequence as used in Theorem 1.1 in Bogdan et. al. (2015)
#' @param X The model matrix
#' @param lambda_length The corrections of the entries of \code{lambda_BH} will be 
#'    computed up to the index given by \code{lambda_length} only.
#' @param number_of_drawings The number of iterations in the Monte Carlo procedure
#'
#' @references M. Bogdan, E. van den Berg, C. Sabatti, W. Su, E. Candes (2015), \emph{SLOPE -- Adaptive variable selection via convex optimization}, \url{http://arxiv.org/abs/1407.3824}
#'
lambdaMC <- function(lambda_BH, X, lambda_length, number_of_drawings = 5000L) {
    .Call('grpSLOPE_lambdaMC', PACKAGE = 'grpSLOPE', lambda_BH, X, lambda_length, number_of_drawings)
}

#' Monte Carlo based Group SLOPE tuning parameter correction
#'
#' \code{lambdaChiMCAdjustment} approximates the variance of (2.25) in Brzyski et. al. (2015)
#'    via Monte Carlo, in order to adjust the lambda sequence for correlations in the  data.
#'
#' The adjustment is computed for the (s+1)st coefficient of lambda, assuming 
#' that the first s coefficients are known. It is required that rank(X) is greater than the 
#' sum of the number of elements in any s groups. 
#'
#' @param y The response vector 
#' @param X The model matrix
#' @param group_id A list obtained from \code{\link{getGroupID}}
#' @param lambda A vector containing the first s entries of lambda
#' @param w A vector of weights per group
#' @param number_of_drawings The number of iterations in the Monte Carlo procedure
#'
#' @references D. Brzyski, W. Su, M. Bogdan (2015), \emph{Group SLOPE -- adaptive selection of groups of predictors}, \url{http://arxiv.org/abs/1511.09078}
#' @references \url{http://www.alexejgossmann.com/grpSLOPE/Lambda/}
#'
lambdaChiMCAdjustment <- function(y, X, group_id, lambda, w, number_of_drawings = 5000L) {
    .Call('grpSLOPE_lambdaChiMCAdjustment', PACKAGE = 'grpSLOPE', y, X, group_id, lambda, w, number_of_drawings)
}

proxSortedL1Rcpp <- function(y, lambda) {
    .Call('grpSLOPE_proxSortedL1Rcpp', PACKAGE = 'grpSLOPE', y, lambda)
}

