% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fit_easylinear.R
\name{fit_easylinear}
\alias{fit_easylinear}
\title{Fit Exponential Growth Model with a Heuristic Linear Method}
\usage{
fit_easylinear(time, y, h = 5, quota = 0.95)
}
\arguments{
\item{time}{vector of independent variable.}

\item{y}{vector of dependent variable (concentration of organisms).}

\item{h}{width of the window (number of data).}

\item{quota}{part of window fits considered for the overall linear fit
(relative to max. growth rate)}
}
\value{
object with parameters of the fit. The lag time is currently estimated
as the intersection between the fit and the horizontal line with \eqn{y=y_0},
where \code{y0} is the first value of the dependent variable. The intersection
of the fit with the abscissa is indicated as \code{y0_lm} (lm for linear model).
These identifieres and their assumptions may change in future versions.
}
\description{
Determine maximum growth rates from the log-linear part of a growth curve using
a heuristic approach similar to the ``growth rates made easy''-method of
Hall et al. (2013).
}
\details{
The algorithm works as follows:
\enumerate{
  \item Fit linear regressions to all subsets of \code{h} consecutive data
    points. If for example \eqn{h=5}, fit a linear regression to points
    1 \dots 5, 2 \dots 6, 3\dots 7 and so on. The method seeks the highest
    rate of exponential growth, so the dependent variable is of course
    log-transformed.
  \item Find the subset with the highest slope \eqn{$b_{max}$}{b_max} and
    include also the data points of adjacent subsets that have a slope of
    at least \eqn{$quota \cdot b_{max}$}{quota * b_max},
    e.g. all data sets that have at least 95\% of the maximum slope.
  \item Fit a new linear model to the extended data window identified in step 2.
}
}
\examples{
data(bactgrowth)

splitted.data <- multisplit(bactgrowth, c("strain", "conc", "replicate"))
dat <- splitted.data[[1]]

plot(value ~ time, data=dat)
fit <- fit_easylinear(dat$time, dat$value)

plot(fit)
plot(fit, log="y")
plot(fit, which="diagnostics")

fitx <- fit_easylinear(dat$time, dat$value, h=8, quota=0.95)

plot(fit, log="y")
lines(fitx, pch="+", col="blue")

plot(fit)
lines(fitx, pch="+", col="blue")


}
\references{
Hall, BG., Acar, H, Nandipati, A and Barlow, M (2014) Growth Rates Made Easy.
Mol. Biol. Evol. 31: 232-38, \doi{10.1093/molbev/mst187}
}
\seealso{
Other fitting functions: 
\code{\link{all_easylinear}()},
\code{\link{all_growthmodels}()},
\code{\link{all_splines}()},
\code{\link{fit_growthmodel}()},
\code{\link{fit_spline}()}
}
\concept{fitting functions}
