% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/testacf_func.R
\name{testacf}
\alias{testacf}
\title{Function to test adjust carried forward}
\usage{
testacf(
  infile,
  seed = 7,
  searchtype = "random",
  grid.length = 9,
  writeout = FALSE,
  outfile = paste0("test_adjustcarryforward_", format(Sys.time(),
    "\%m-\%d-\%Y_\%H-\%M-\%S")),
  quietly = FALSE,
  param = "none",
  debug = FALSE,
  maxrecs = 0,
  exclude_opt = 0,
  add_answers = TRUE
)
}
\arguments{
\item{infile}{Input data frame/data table, cleaned by cleangrowth(), with columns as described in main README.md}

\item{seed}{Numeric random seed, used only when performing random search}

\item{searchtype}{Type of search to perform: random (default), line-grid,
full-grid}

\item{grid.length}{Number of steps in grid to search}

\item{writeout}{Write output to file? Default FALSE.}

\item{outfile}{"Output file name, default 'test_adjustcarrforward_DATE_TIME', where DATE is the current system date and time"}

\item{quietly}{Verbose progress info}

\item{param}{"none", or data frame to specify which parameters to run full search on, and values to use if not, used only when performing full-grid search}

\item{debug}{Produce extra data files for debugging}

\item{maxrecs}{Limit to specified # subjects, default 0 (no limit)}

\item{exclude_opt}{Type of exclusion method for carried forward strings, 0 to 3. See adjustcarryforward documentation for more information}

\item{add_answers}{TRUE or FALSE, indicating whether or not to add answers (definely include/exclude) for the given dataset. Defaults to TRUE}
}
\value{
A list containing:
testacf_res: data frame with adjustcarryforward results for each run,
params: a data frame containing parameter values for each run.
debug_filtered_data: data frame with original data, returned if debug TRUE
}
\description{
The goal of this script is to consider the height values that growthcleanr
excludes as “carried forward” for potential re-inclusion by using a reverse
absolute height velocity check based on step 15 of the Daymont et al.
algorithm
}
