% Generated by roxygen2 (4.0.1): do not edit by hand
\name{predict_functions.gpdpgrow}
\alias{predict_functions.gpdpgrow}
\title{Use the model-estimated GP covariance parameters from gpdpgrow() to predict the GP function at
future time points.  Inputs the \code{gpdpgrow} object of estimated parameters.}
\usage{
\method{predict_functions}{gpdpgrow}(object, J = 500, test_times,
  time_points = NULL, sn_order = NULL, ...)
}
\arguments{
\item{object}{Object of class \code{gpdpgrow} returned from model run of \code{gpdpgrow()}}

\item{J}{Scalar denoting number of draws to take from posterior predictive for each unit.
Defaults to \code{J = 500}.}

\item{test_times}{A numeric vector holding test times at which to predict GP function values
Will use the estimated covariance parameters from the training data to predict
functions at the test_times for the \code{N} observation units.}

\item{time_points}{Inputs a vector of common time points at which the collections of functions were
observed (with the possibility of intermittent missingness).  The length of \code{time_points}
should be equal to the number of columns in the data matrix, \code{y}.  Defaults to
\code{time_points = 1:ncol(y)}.}

\item{sn_order}{An integer vector of length, \code{L_s}, equal to the number of seasonal terms.
Conveys the order of the seasonality for each term on the scale of T; for example,
if T is dimensioned in months, and one wishes to model quarterly seasonality, then
the applicable seasonality term would be of order \code{3}.}

\item{...}{further arguments passed to or from other methods.}
}
\value{
out  A list object containing containing two matrices; the first is a K x (N*T)
                 matrix of predicted function values for each of K sampled iterations.  N is
                 slow index and denotes the number of experimental units.  The second matrix is
                 an N x T average over the K sampled draws, composed in Rao-Blackwellized fashion.
}
\description{
A companion function to \code{\link{gpdpgrow}}
}
\note{
Intended as a companion function for \code{\link{gpdpgrow}} for prediction
}
\examples{
\dontrun{
library(growfunctions)
data(cps)
y_short   <- cps$y[,(cps$yr_label \%in\% c(2010:2013))]
t_train   <- ncol(y_short)
N         <- nrow(y_short)
t_test    <- 4

## Model Runs
res_gp              = gpdpgrow(y = y_short
                              n.iter = 50,
                              n.burn = 25,
                              n.thin = 1,
                              n.tune = 0)

## Prediction Model Runs
T_test             <- 4
T_yshort           <- ncol(y_short)
pred_gp            <- predict_functions( object = res_gp,
                       test_times = (T_yshort+1):(T_yshort+T_test) )

## plot estimated and predicted functions
plot_gp         <- predict_plot(object = pred_gp,
                               units_label = cps$st,
                               single_unit = FALSE,
                               credible = TRUE)
}
}
\author{
Terrance Savitsky \email{tds151@gmail.com}
}
\seealso{
\code{\link{gpdpgrow}}
}

