% Generated by roxygen2 (4.0.1): do not edit by hand
\name{gmrfdpPost}
\alias{gmrfdpPost}
\title{Run a Bayesian functional data model under an instrinsic GMRF prior whose precision parameters
employ a DP prior}
\usage{
gmrfdpPost(y, ipr, C, D, q_order, q_type, n.iter, n.burn, n.thin, M_init,
  q_shape, q_rate, tau_shape, tau_rate, dp_shape, dp_rate, progress, jitter,
  kappa_fast)
}
\arguments{
\item{y}{An \emph{N x T} matrix of N observations of \emph{T x 1} functions}

\item{ipr}{An optional input vector of inclusion probabilities for each observation unit in the case
the observed data were acquired through an informative sampling design, so that unbiased
inference about the population requires adjustments to the observed sample.  Defaults to
\code{ipr = rep(1,nrow(y))} indicating an iid sample.}

\item{C}{A list object of length, \code{K}, the number of iGMRF precision terms.
Each entry contains a \emph{T x T} normalized adjacency matrix.  The diagonal entries are
\code{0} and row \code{i} contains the weight for each entry {!=i} divided by the sum
of the weights.}

\item{D}{A \emph{K x T} matrix, where \code{K} denotes the number of iGMRF terms.
Row \code{k} contains the \code{T} elements of the diagonal of the term-\code{k}
precision matrix, \code{Q_k}.
Will increase with order and be equal, except for boundary corrections.}

\item{q_order}{An integer vector where each entry contains the order of the associated \code{K}
iGMRF precision terms
matrix of Euclidean distances associated to each seasonal covariance term.}

\item{q_type}{A vector of length \code{K}, the number of iGMRF precision terms, with each entry
indicating whether the associated term is a trend (\code{"tr"}) or
seasonality (\code{"sn"}) term.}

\item{tau_shape}{The value (in (0,infty)) for the shape hyperparameter for the Gamma prior on the error
precision parameter. Defaults to \code{tau_shape = 1.0}.}

\item{tau_rate}{The rate parameter of the Gamma prior distribution on \code{tau_e}.
Defaults to \code{tau_rate = 1}.}

\item{n.iter}{The number of MCMC sampling iterations}

\item{n.burn}{The number of warm-up iterations to discard}

\item{n.thin}{The interval or step size of post-burn-in samples to return}

\item{M_init}{Starting value of number of clusters for sampling cluster assignments.}

\item{q_shape}{The shape parameter of the Gamma base distribution for the \code{kappa_star}
locations used to sample the DP prior on the \code{P} GP covariance parameters,
\code{kappa}, for each experimental unit.}

\item{q_rate}{The rate parameter of the Gamma base distribution for the \code{kappa_star}
locations used to sample the DP prior on the \code{P} GP covariance parameters,
\code{kappa}, for each experimental unit.}

\item{dp_shape}{The shape parameter for the \eqn{\Gamma} prior on the DP concentration parameter.
The rate parameter is set of \code{1}.}

\item{dp_rate}{The rate parameter for the \eqn{\Gamma} prior on the DP concentration parameter.
Default value is \code{1}.}

\item{progress}{An indicator in \code{{0,1}} denoting whether to display a progress bar during model execution.
\code{progress = 1} displays a progress bar. Defaults to \code{progress = 1}.}

\item{jitter}{A scalar double indicating amount of jitter to subract from the posterior
rate and shape hyperparameters of \code{tau_e} to stabilize computation.
Defaults to \code{jitter = 0.0}.}

\item{kappa_fast}{Boolean for whether to generate rate hyperparameter from full conditionals
versus joint Gaussian (on random effects, \code{bb}, given \code{kappa}.  The
former is faster, but numerically less stable.
Defaults to \code{kappa_fast = FALSE}.}
}
\value{
res A list object containing MCMC runs for all model parameters.
}
\description{
An internal function to \code{\link{gmrfdpgrow}}
}
\note{
Intended as an internal function for \code{\link{gmrfdpgrow}}
}
\author{
Terrance Savitsky \email{tds151@gmail.com}
}
\seealso{
\code{\link{gpdpgrow}}
}

