% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\docType{data}
\name{parameter_scan_example}
\alias{parameter_scan_example}
\title{Example results of a parameter scan}
\format{
A list containing an entry for each supplied parameter set
in \emph{param_values}. Each entry is itself a list containing the following
keys:
\describe{
\item{params}{The parameter set that was used to run growR for this
entry.}
\item{data}{A list containing for each simulated year a \link{ModvegeSite}
object which was run for the respective year and therefore carries the
respective results.}
}
}
\usage{
parameter_scan_example
}
\description{
The function \code{\link[=run_parameter_scan]{run_parameter_scan()}} can take a significant time to
execute, as it typically requires a few dozen model evaluations or more.
In order to still showcase what its output can look like, and to
facilitate testing and giving examples in the documentation of tools that
make use of the output of \code{\link[=run_parameter_scan]{run_parameter_scan()}} (such as e.g.
\code{\link[=analyze_parameter_scan]{analyze_parameter_scan()}}), this example dataset is provided.
}
\details{
The input for the parameter scan that produced this output was:
\itemize{
\item 

\if{html}{\out{<div class="sourceCode param_values = list(w_FGA = seq(0.25, 1, 0.25),">}}\preformatted{                       w_FGB = seq(0.25, 1, 0.25),
                       w_FGC = seq(0, 0.25, 0.25),
                       w_FGD = c(0),
                       NI = seq(0.75, 1.0, 0.25)
}\if{html}{\out{</div>}}
}

\if{html}{\out{<div class="sourceCode">}}\preformatted{- `eps = 2e-2`
)
}\if{html}{\out{</div>}}
}
\seealso{
\code{\link[=run_parameter_scan]{run_parameter_scan()}}
}
\keyword{datasets}
