% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/support_functions.R
\name{aCO2_inverse}
\alias{aCO2_inverse}
\title{Concentration representative year}
\usage{
aCO2_inverse(aCO2)
}
\arguments{
\item{aCO2}{Target CO2 concentration in ppm.}
}
\value{
year Approximate year (as floating point number) by which target 
  concentration is reached.
}
\description{
Inverse of `atmospheric_CO2`: retrieve the year by which a given CO2 
concentration is reached.
}
\details{
Does not give a reasonable result for values below 317ppm, corresponding 
to the year 1949, as this is where the minimum of the parabola is located 
in the second order fit to the data that was used in aCO2.fct.
}
\examples{
aCO2_inverse(420)
aCO2_inverse(700)
# Insensible
aCO2_inverse(100)

}
