% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/PlotFun.R
\name{PlotFun}
\alias{PlotFun}
\title{Function to plot the denoised signal}
\usage{
PlotFun(data, p = c(0.025, 0.5, 0.975), band.type = "pointwise",
  main = "", col = "blue", type = "l", ylab = "", xlab = "",
  ylim = NULL)
}
\arguments{
\item{data}{Matrix of posterior samples.}

\item{p}{Vector with the lower, center and upper quantile.}

\item{band.type}{Type of credible intervals. The options are:
\code{pointwise}, \code{gloabl} or \code{global}.}

\item{main}{The main title of the plot.}

\item{col}{The color of the point estimate.}

\item{type}{The type of line of the point estimate.}

\item{ylab}{The label of the y-axis.}

\item{xlab}{The label of the x-axis.}

\item{ylim}{The range of the y-axis.}
}
\value{
A plot.
}
\description{
This function plots the credible bounds of the denoised signal.
}
\examples{
data <- wavethresh::DJ.EX(n = 512, noisy = TRUE, rsnr = 5)$doppler
W <- DWT(data)
ans <- Denoise(W)
denoised.data <- InvDWT(ans)
PlotFun(denoised.data)
PlotFun(denoised.data, band.type = "both")
}

