% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/op_ppp.R
\name{op_ppp}
\alias{op_ppp}
\alias{dist_ppp}
\alias{fv_ppp}
\title{Operations on \link[spatstat.geom]{ppp.object}}
\usage{
dist_ppp(x, fn, ...)

fv_ppp(x, fn, ...)
}
\arguments{
\item{x}{a \link[spatstat.geom]{ppp.object}}

\item{fn}{a distance \link[base]{function},
or a \link[base]{function} that returns an \link[spatstat.explore]{fv.object},
see \strong{Details}}

\item{...}{additional parameters of function \code{fn}}
}
\value{
Function \code{\link[=fv_ppp]{fv_ppp()}} returns a \link[base]{list} of
\link[spatstat.explore]{fv.object}s,
one for each eligible \link[spatstat.geom]{marks}.

Function \code{\link[=dist_ppp]{dist_ppp()}} returns a \link[base]{list} of
\link[base]{double} \link[base]{vector}s,
one for each eligible \link[spatstat.geom]{marks}.
}
\description{
Create
\link[spatstat.explore]{fv.object}s
or
distances
from a \link[spatstat.geom]{ppp.object}.
}
\details{
First, the input \link[spatstat.geom]{ppp.object} is \link[spatstat.geom]{unstack.ppp}-ed.

Each of the \link[base]{numeric} \link[spatstat.geom]{marks} could be analyzed by
following functions that return an \link[spatstat.explore]{fv.object},
\itemize{
\item {\link[spatstat.explore]{Emark}}
\item {\link[spatstat.explore]{Vmark}}
\item {\link[spatstat.explore]{markcorr}}
\item {\link[spatstat.explore]{markvario}}
}
If one of the functions above are provided
but there is no \link[base]{numeric} \link[spatstat.geom]{marks} in the input,
a \code{NULL} value will be returned.

Each of the \link[spatstat.geom]{marks} that \link[spatstat.geom]{is.multitype}
could be analyzed
by following functions that return an \link[spatstat.explore]{fv.object},
\itemize{
\item {\link[spatstat.explore]{Gcross}}
\item {\link[spatstat.explore]{Jcross}}
\item {\link[spatstat.explore]{Kcross}}
\item {\link[spatstat.explore]{Lcross}}
\item {\link[spatstat.explore]{markconnect}}
}
or by following functions that return a distance,
\itemize{
\item {\code{\link[=.nncross]{.nncross()}}}
}
If one of the functions above are provided
but there is no \link[spatstat.geom]{marks} \link[spatstat.geom]{is.multitype} in the input,
a \code{NULL} value will be returned.
}
\examples{
library(spatstat.data)
library(spatstat.explore)

fv_ppp(betacells, fn = Emark) # applicable to numeric mark
fv_ppp(betacells, fn = Gcross, i = 'off', j = 'on') # applicable to multitype mark

dist_ppp(betacells, fn = .nncross, i = 'off', j = 'on')
dist_ppp(gorillas, fn = .nncross, i = 'major', j = 'minor')
dist_ppp(gorillas, fn = .nncross, i = 'rainy', j = 'dry')
}
\keyword{internal}
