% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/as.groupedHyperframe.R
\name{as.groupedHyperframe}
\alias{as.groupedHyperframe}
\alias{as.groupedHyperframe.hyperframe}
\title{Creation of \code{groupedHyperframe}}
\usage{
as.groupedHyperframe(x, ...)

\method{as.groupedHyperframe}{hyperframe}(x, group, ...)
}
\arguments{
\item{x}{see Usage}

\item{...}{additional parameters}

\item{group}{\link[stats]{formula}}
}
\value{
Function \code{\link[=as.groupedHyperframe]{as.groupedHyperframe()}} returns a \code{groupedHyperframe}.
}
\description{
To create a \code{groupedHyperframe} object
}
\examples{
library(spatstat.data)

# ?spatstat.data::osteo
# `brick`: serial number (1 to 10) of sampling volume within this bone sample (`id`)
head(as.groupedHyperframe(osteo, group = ~ id/brick))

# ?spatstat.data::flu
# `frameid`: not unique across different values of `virustype` and `stain`.
# currently not supporting
# group = ~ virustype*stain/flu
head(tmp <- with(unclass(flu)$df, expr = data.frame(
  virus.stain = interaction(virustype, stain, drop = TRUE, sep = '_', lex.order = TRUE)
)))
head(flu2 <- spatstat.geom::cbind.hyperframe(flu, tmp))
head(as.groupedHyperframe(flu2, group = ~ virus.stain/frameid))
}
\keyword{internal}
