% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/roxy.R
\name{roxy}
\alias{roxy}
\title{'Groq': Code Documentation in roxygen2 style or any other}
\usage{
roxy(code = NULL, inLineDocumentation = "roxygen2", ...)
}
\arguments{
\item{code}{The code to be documented by 'Groq'. If not provided,
it will use what's copied on the clipboard.}

\item{inLineDocumentation}{any documentation style. Defaults to roxygen2.}

\item{...}{Following arguments can be set manually or in .Renviron:
\code{GROQ_API_KEY}is the 'Groq API' key.
\code{model} Model choice. Default is mistral-7b-instruct.
\code{systemRole} System role; Default is: "You are a helpful assistant
with extensive knowledge of R programming."
\code{maxTokens} The maximum integer of completion tokens returned.
\code{temperature} The amount of randomness in the response,
valued between 0 inclusive and 2 exclusive. Higher values are more
random, and lower values are more deterministic.
\code{top_p} Nucleus sampling threshold, valued between 0 and 1.
\code{proxy} Default value is NULL.}
}
\value{
A character value with the response generated by 'Groq'.
}
\description{
'Groq': Code Documentation in roxygen2 style or any other
}
\examples{
\dontrun{
cat(roxy("z <- function(x) scale(x)^2"))
}

}
