\name{drFitSpline}
\Rdversion{1.1}
\alias{drFitSpline}
\title{
Function to fit smoothed splines to dose reponse data.
}
\description{
The function fits dose response curves.
}
\usage{
drFitSpline(conc, test, drID = "undefined",
            control = grofit.control())
}
\arguments{
  \item{conc}{
Numeric vector, concentration (dose) data.
}
  \item{test}{
Numeric vector, response data beloning to \code{conc}.
}
  \item{drID}{
Character, identifying the dose response data.
}
  \item{control}{
Object of class \code{grofit.control} containing a list of options generated by the function \link{grofit.control}.
}
}
\details{
The function uses the R internal function \code{\link{smooth.spline}} to fit a spline to the provided data. From the resulting curve the EC50 value is calculated.
}
\value{
Generates an object of class \code{drFit}
\item{raw.conc}{Raw data provided to the function as \code{conc}.}
\item{raw.test}{Raw data provided to the function as \code{test}.}
\item{drID}{Character, identifying the dose response data.}
\item{fit.conc}{Fitted concentration values.}
\item{fit.test}{Fitted response values.}
\item{spline}{\code{nls} object generated by the \code{\link{smooth.spline}} function.}
\item{fitFlag}{Logical, indicating wether a spline could fitted successfully to data.}
\item{reliable}{Logical, indicating wether the provided data is reliable (to be set manually).}
\item{control}{Object of class \code{grofit.control} containing a list of options passed to the function as \code{control}.}
\item{parameters}{List of parameters estimated from dose response curve fit.}
\item{EC50}{Half maximal concentration.}
\item{yEC50}{Response value related to EC50.}
\item{EC50.orig}{EC50 value in original scale, if a transformation was applied.}
\item{xEC50.orig}{Response value for EC50 in original scale, if a transformation was applied.}
}
\examples{
x <- 1:30
y <- 1/(1+exp(-0.5*(15-x)))+rnorm(30)/20
TestRun <- drFitSpline(x,y)
print(summary(TestRun))
plot(TestRun)
}
\seealso{
\code{\link{drFit}}, \code{\link{summary.drFitSpline}}, \code{\link{plot.drFitSpline}}
}
