% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/analysis_tools.R
\name{get_leaf_node}
\alias{get_leaf_node}
\title{Find the leaf node for a test sample.}
\usage{
get_leaf_node(tree, newdata, node.id = TRUE)
}
\arguments{
\item{tree}{A GRF tree object (retrieved by `get_tree`).}

\item{newdata}{Points at which leaf predictions should be made.}

\item{node.id}{Boolean indicating whether to return the node.id for each query sample (default), or
if FALSE, a list of node numbers with the samples contained.}
}
\value{
A vector of integers indicating the leaf number for each sample in the given tree.
}
\description{
Given a GRF tree object, compute the leaf node a test sample falls into. The nodes in a GRF tree
are numbered breadth first, and the returned numbers will be the leaf integer according
to this ordering. To get kernel weights based on leaf membership, see the function
\code{\link{get_forest_weights}}.
}
\examples{
\donttest{
p <- 10
n <- 100
X <- matrix(2 * runif(n * p) - 1, n, p)
Y <- (X[, 1] > 0) + 2 * rnorm(n)
r.forest <- regression_forest(X, Y, num.tree = 50)

n.test <- 5
X.test <- matrix(2 * runif(n.test * p) - 1, n.test, p)
tree <- get_tree(r.forest, 1)
# Get a vector of node numbers for each sample.
get_leaf_node(tree, X.test)
# Get a list of samples per node.
get_leaf_node(tree, X.test, node.id = FALSE)
}

}
