% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/methods.R
\name{actuals}
\alias{actuals}
\alias{actuals.default}
\alias{actuals.lm}
\alias{actuals.alm}
\title{Function extracts the actual values from the function}
\usage{
actuals(object, all = TRUE, ...)

\method{actuals}{default}(object, all = TRUE, ...)

\method{actuals}{lm}(object, all = TRUE, ...)

\method{actuals}{alm}(object, all = TRUE, ...)
}
\arguments{
\item{object}{Model estimated using one of the functions of smooth package.}

\item{all}{If \code{FALSE}, then in the case of the occurrence model, only demand
sizes will be returned.}

\item{...}{Other parameters to pass to the method. Currently nothing is supported here.}
}
\value{
The vector of the response variable.
}
\description{
This is a simple method that returns the values of the response variable of the model
}
\examples{

xreg <- cbind(rnorm(100,10,3),rnorm(100,50,5))
xreg <- cbind(100+0.5*xreg[,1]-0.75*xreg[,2]+rnorm(100,0,3),xreg,rnorm(100,300,10))
colnames(xreg) <- c("y","x1","x2","Noise")

ourModel <- stepwise(xreg)

actuals(ourModel)

}
\author{
Ivan Svetunkov, \email{ivan@svetunkov.ru}
}
