% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bcnorm.R
\name{dbcnorm}
\alias{dbcnorm}
\alias{pbcnorm}
\alias{qbcnorm}
\alias{rbcnorm}
\title{Box-Cox Normal Distribution}
\usage{
dbcnorm(q, mu = 0, sigma = 1, lambda = 0, log = FALSE)

pbcnorm(q, mu = 0, sigma = 1, lambda = 0)

qbcnorm(p, mu = 0, sigma = 1, lambda = 0)

rbcnorm(n = 1, mu = 0, sigma = 1, lambda = 0)
}
\arguments{
\item{q}{vector of quantiles.}

\item{mu}{vector of location parameters (means).}

\item{sigma}{vector of scale parameters.}

\item{lambda}{the value of the Box-Cox transform parameter.}

\item{log}{if \code{TRUE}, then probabilities are returned in
logarithms.}

\item{p}{vector of probabilities.}

\item{n}{number of observations. Should be a single number.}
}
\value{
Depending on the function, various things are returned
(usually either vector or scalar):
\itemize{
\item \code{dbcnorm} returns the density function value for the
provided parameters.
\item \code{pbcnorm} returns the value of the cumulative function
for the provided parameters.
\item \code{qbcnorm} returns quantiles of the distribution. Depending
on what was provided in \code{p}, \code{mu} and \code{sigma}, this
can be either a vector or a matrix, or an array.
\item \code{rbcnorm} returns a vector of random variables
generated from the bcnorm distribution. Depending on what was
provided in \code{mu} and \code{sigma}, this can be either a vector
or a matrix or an array.
}
}
\description{
Density, cumulative distribution, quantile functions and random number
generation for the distribution that becomes normal after the Box-Cox
transformation. Note that this is based on the original Box-Cox paper.
}
\details{
The distribution has the following density function:

f(x) = x^{lambda-1} 1/sqrt(2 pi) exp(-((y^lambda-1)/lambda -mu)^2 / (2 sigma^2))

Both \code{pbcnorm} and \code{qbcnorm} are returned for the lower
tail of the distribution.

In case of lambda=0, the values of the log normal distribution are returned.
In case of lambda=1, the values of the normal distribution are returned with mu=mu+1.

All the functions are defined for non-negative values only.
}
\examples{
x <- dbcnorm(c(-1000:1000)/200, 0, 1, 1)
plot(c(-1000:1000)/200, x, type="l")

x <- pbcnorm(c(-1000:1000)/200, 0, 1, 1)
plot(c(-1000:1000)/200, x, type="l")

qbcnorm(c(0.025,0.975), 0, c(1,2), 1)

x <- rbcnorm(1000, 0, 1, 1)
hist(x)

}
\references{
\itemize{
\item Box, G. E., & Cox, D. R. (1964). An Analysis of Transformations.
Journal of the Royal Statistical Society. Series B (Methodological),
26(2), 211–252. Retrieved from https://www.jstor.org/stable/2984418
}
}
\author{
Ivan Svetunkov, \email{ivan@svetunkov.ru}
}
\keyword{distribution}
