% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gr_setters.R
\name{setRootDepSet}
\alias{setRootDepSet}
\alias{setRootDepSet.RootDepSet}
\title{Setter for objects of class \code{RootDepSet}}
\usage{
setRootDepSet(obj, subset, root, ...)

\method{setRootDepSet}{RootDepSet}(obj, subset, root, ...)
}
\arguments{
\item{obj}{Object of class \code{RootDepSet}}

\item{subset}{list containing the subsets on the set of vertices, referred by their names.
An element of the list should
be named with the name of the corresponding root to that subset.}

\item{root}{One dimensional array of the roots, corresponding to the subsets above
referred by name.}

\item{...}{additional arguments}
}
\value{
An object of class \code{RootDepSet} with non empty slots \code{$value} and \code{$root} which
are assigned the arguments \code{subset} and \code{root} respectively.
}
\description{
It is used to set the slots \code{$value} and \code{$root} of an object of class \code{RootDepSet} and
its subclasses, such as \code{Neighborhood} and \code{FlowConnect}. Every node in the graph with observable
variable
must be taken as a root. For a fixed root, a subset of nodes must be chosen.
}
\examples{
rds<- RootDepSet()
rds_values<- list(a = c("a", "b"), b = c("b", "c", "d"))
rds_roots<- c("a", "b")
rds<- setRootDepSet(rds, rds_values, rds_roots)
}
