% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{eval_gfparam}
\alias{eval_gfparam}
\title{Evaluate all combination of parameters}
\usage{
eval_gfparam(data, start_date, end_date, cutoff)
}
\arguments{
\item{data}{a data frame with preliminary or finalized 'GreenFeed' data}

\item{start_date}{a character string representing the start date of the study (format: "dd/mm/yyyy")}

\item{end_date}{a character string representing the end date of the study (format: "dd/mm/yyyy")}

\item{cutoff}{an integer specifying the range for identifying outliers (default: 3 SD)}
}
\value{
A data frame with the mean, SD, and CV for gas production using all possible combination of parameters
}
\description{
Evaluate parameters that best fit your 'GreenFeed' data
}
\examples{
file <- readr::read_csv(system.file("extdata", "StudyName_GFdata.csv", package = "greenfeedr"))
eval <- eval_gfparam(data = file,
                     start_date = "2024-05-13",
                     end_date = "2024-05-20"
                    )

}
\keyword{internal}
