% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/BS_European_Greeks_test.R
\name{BS_European_Greeks_test}
\alias{BS_European_Greeks_test}
\title{Computes the Greeks of an European call- or put-option in the Black Scholes
model}
\usage{
BS_European_Greeks_test(
  initial_price = 100,
  exercise_price = 100,
  r = 0,
  time_to_maturity = 1,
  volatility = 0.3,
  dividend_yield = 0,
  payoff = "call",
  greek = c("fair_value", "delta", "vega", "theta", "rho", "epsilon", "lambda",
    "gamma", "vanna", "charm", "vomma", "veta", "speed")
)
}
\arguments{
\item{initial_price}{\itemize{
\item initial price of the underlying asset
}}

\item{exercise_price}{\itemize{
\item strike price of the option
}}

\item{r}{\itemize{
\item risk-free interest rate
}}

\item{time_to_maturity}{\itemize{
\item time to maturity in years
}}

\item{volatility}{\itemize{
\item volatility of the underlying asset
}}

\item{dividend_yield}{\itemize{
\item dividend yield
}}

\item{payoff}{\itemize{
\item in "call", "put", "cash_or_nothing_call",
"cash_or_nothing_put", "asset_or_nothing_call", "asset_or_nothing_put"
}}

\item{greek}{\itemize{
\item Greeks to be calculated in c("fair_value", "delta", "vega",
"theta", "rho", "epsilon", "lambda", "gamma", "vanna", "charm", "vomma",
"veta", "speed")
}}
}
\value{
Named vector containing the values of the greeks specified in the
parameter \code{greek}.
}
\description{
Computes the Greeks of an European call- or put-option in the Black Scholes
model
}
\examples{
BS_European_Greeks(initial_price = 120, exercise_price = 100,
r = 0.02, time_to_maturity = 4.5, dividend_yield = 0.015, volatility = 0.22,
greek = c("fair_value", "delta", "gamma"), payoff = "put")
}
