% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/BS_Malliavin_Asian_Greeks.R
\name{BS_Malliavin_Asian_Greeks}
\alias{BS_Malliavin_Asian_Greeks}
\title{Computes the Greeks of an Asian option with the Malliavin Monte Carlo
Method in the Black Scholes model}
\usage{
BS_Malliavin_Asian_Greeks(
  initial_price = 100,
  exercise_price = 100,
  r = 0,
  time_to_maturity = 1,
  volatility = 0.3,
  dividend_yield = 0,
  payoff = "call",
  steps = round(time_to_maturity * 252),
  paths = 10000,
  seed = 1,
  greek = c("fair_value", "delta", "rho", "theta", "vega", "gamma"),
  antithetic = FALSE
)
}
\arguments{
\item{initial_price}{\itemize{
\item initial price of the underlying asset
}}

\item{exercise_price}{\itemize{
\item strike price of the option
}}

\item{r}{\itemize{
\item risk-free interest rate
}}

\item{time_to_maturity}{\itemize{
\item time to maturity in years
}}

\item{volatility}{\itemize{
\item volatility of the underlying asset
}}

\item{dividend_yield}{\itemize{
\item dividend yield
}}

\item{payoff}{\itemize{
\item the payoff function, either a string in ("call", "put",
"digital_call", "digital_put"), or a function
}}

\item{steps}{\itemize{
\item the number of integration steps
}}

\item{paths}{\itemize{
\item the number of simulated paths
}}

\item{seed}{\itemize{
\item the seed of the random number generator
}}

\item{greek}{\itemize{
\item the Greek to be calculated
}}

\item{antithetic}{\itemize{
\item if TRUE, antithetic random numbers will be chosen to
decrease variance
}}
}
\value{
Named vector containing the values of the Greeks specified in the
parameter \code{greek}.
}
\description{
Computes the Greeks of an Asian option with the Malliavin Monte Carlo
Method in the Black Scholes model
}
