% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/model_diaggmm.R
\docType{class}
\name{DiagGmm}
\alias{DiagGmm}
\alias{DiagGmmPrior-class}
\alias{DiagGmm-class}
\alias{DiagGmmPrior}
\title{Diagonal Gaussian Mixture Model Prior description class}
\usage{
DiagGmmPrior(tau = 0.01, kappa = 1, beta = NaN, mu = NaN)

DiagGmm(alpha = 1, tau = 0.01, kappa = 1, beta = NaN, mu = NaN)
}
\arguments{
\item{tau}{Prior parameter (inverse variance), (default 0.01)}

\item{kappa}{Prior parameter (gamma shape), (default to 1)}

\item{beta}{Prior parameter (gamma rate), (default to NaN, in this case beta will be estimated from data as 0.1 time the mean of X columns variances)}

\item{mu}{Prior for the means (vector of size D), (default to NaN, in this case mu will be estimated from data as the mean of X)}

\item{alpha}{Dirichlet prior parameter over the cluster proportions (default to 1)}
}
\value{
a \code{DiagGmmPrior-class} object

a \code{DiagGmm-class} object
}
\description{
An S4 class to represent a multivariate diagonal Gaussian mixture model.
The model corresponds to the following generative model:
\deqn{ \pi \sim Dirichlet(\alpha)}
\deqn{ Z_i  \sim \mathcal{M}(1,\pi)}
\deqn{ \lambda_k^{(d)} \sim \mathcal{G}(\kappa,\beta)}
\deqn{ \mu_k^{(d)} \sim \mathcal{N}(\mu,(\tau \lambda_k)^{-1})}
\deqn{ X_{i.}|Z_{ik}=1 \sim \mathcal{N}(\mu_k,\lambda_{k}^{-1})}
with \eqn{\mathcal{G}(\kappa,\beta)} the Gamma distribution with shape parameter \eqn{\kappa} and rate parameter \eqn{\beta}.
These classes mainly store the prior parameters value (\eqn{\alpha,\tau,\kappa\beta,\mu}) of this generative model.
The \code{DiagGmm-class} must be used when fitting a simple Diagonal Gaussian Mixture Model whereas the \code{DiagGmmPrior-class} must be sued when fitting a \code{\link{CombinedModels-class}}.
}
\examples{
DiagGmmPrior()
DiagGmmPrior(tau = 0.1)
DiagGmm()
DiagGmm(tau = 0.1)
}
\references{
Bertoletti, Marco & Friel, Nial & Rastelli, Riccardo. (2014). Choosing the number of clusters in a finite mixture model using an exact Integrated Completed Likelihood criterion. METRON. 73. 10.1007/s40300-015-0064-5. #'
}
\seealso{
\code{\link{DiagGmmFit-class}}, \code{\link{DiagGmmPath-class}}

Other DlvmModels: 
\code{\link{CombinedModels}},
\code{\link{DcLbm}},
\code{\link{DcSbm}},
\code{\link{DlvmPrior-class}},
\code{\link{Gmm}},
\code{\link{Lca}},
\code{\link{MoM}},
\code{\link{MoR}},
\code{\link{MultSbm}},
\code{\link{Sbm}},
\code{\link{greed}()}
}
\concept{DlvmModels}
