# Generated by using Rcpp::compileAttributes() -> do not edit by hand
# Generator token: 10BE3573-1514-4C36-9D1C-5A225CD40393

#' @title IncomeTax
#' @description Calculates the ordinary tax payable given income and tax thresholds and rates.
#' Basic, designed for performance.
#' @name IncomeTax
#' @param x Taxable income.
#' @param thresholds Lower brackets of the tax tables.
#' @param rates Marginal rates
#' @export IncomeTax
NULL

IncomeTax <- function(x, thresholds, rates) {
    .Call(`_grattan_IncomeTax`, x, thresholds, rates)
}

#' @title Medicare levy in C++
#' @description Medicare levy. Experimental function in C++, equivalent to \code{\link{medicare_levy}}.
#' @name MedicareLevy
#' @param income,SpouseIncome,SaptoEligible,isFamily,nDependants,lowerThreshold,upperThreshold,lowerFamilyThreshold,upperFamilyThreshold,lowerUpForEachChild As in \code{medicare_levy}.
#' @param rate,taper The parameters for the specific year or hypothetical requested.
#' @export MedicareLevy 
NULL

MedicareLevySingle <- function(income, lowerThreshold, upperThreshold, rate = 0.02, taper = 0.2, SpouseIncome = 0, isFamily = FALSE, nDependants = 0L, lowerFamilyThreshold = 46000, upperFamilyThreshold = 54119, lowerUpForEachChild = 3306) {
    .Call(`_grattan_MedicareLevySingle`, income, lowerThreshold, upperThreshold, rate, taper, SpouseIncome, isFamily, nDependants, lowerFamilyThreshold, upperFamilyThreshold, lowerUpForEachChild)
}

MedicareLevySaptoYear <- function(income, SpouseIncome, NDependants, sapto, yr) {
    .Call(`_grattan_MedicareLevySaptoYear`, income, SpouseIncome, NDependants, sapto, yr)
}

MedicareLevy <- function(income, lowerThreshold, upperThreshold, SpouseIncome, isFamily, NDependants, lowerFamilyThreshold, upperFamilyThreshold, lowerUpForEachChild, rate = 0.02, taper = 0.1) {
    .Call(`_grattan_MedicareLevy`, income, lowerThreshold, upperThreshold, SpouseIncome, isFamily, NDependants, lowerFamilyThreshold, upperFamilyThreshold, lowerUpForEachChild, rate, taper)
}

#' @title General offset in C++
#' @name Offset
#' @description Calculate the offset given a threshold, a maximum offset, and a taper. 
#' @param x A vector of incomes etc.
#' @param y The maximum offset available; the offset when \code{x} is zero.
#' @param a The maximum value of \code{x} at which the maximum offset is available.
#' @param m The taper rate (the \strong{negative} slope).
#' @export Offset
NULL

Offset <- function(x, y, a, m) {
    .Call(`_grattan_Offset`, x, y, a, m)
}

#' @title Threeway parallel maximum
#' @description Returns the parallel maximum of three 
#' 
#' @name pmax3
#' @param x,y,z Numeric vectors of identical lengths.
#' @return The parallel maximum of the vectors.
#' @export pmax3
NULL

pmax3 <- function(x, y, z) {
    .Call(`_grattan_pmax3`, x, y, z)
}

#' @title Parallel maximum
#' @description A faster \code{pmax()}.
#'
#' @name pmaxC
#' @param x A numeric vector.
#' @param a A single numeric value.
#' @return The parallel maximum of the input values.
#' @note This function will always be faster than \code{pmax(x, a)} when \code{a} is a single value, but can be slower than \code{pmax.int(x, a)} when \code{x} is short. Use this function when comparing a numeric vector with a single value.
#' @export pmaxC
NULL

pmaxC <- function(x, a) {
    .Call(`_grattan_pmaxC`, x, a)
}

#' @title Parallel maximum
#' @description A faster \code{pmax()}.
#'
#' @name pmaxV
#' @param x A numeric vector.
#' @param y A numeric vector, the same length as x.
#' @return The parallel maximum of the input values.
#' @export pmaxV
NULL

pmaxV <- function(x, y) {
    .Call(`_grattan_pmaxV`, x, y)
}

#' @title Parallel maximum
#' @description A faster \code{pmin()}.
#'
#' @name pminC
#' @param x A numeric vector.
#' @param a A single numeric value.
#' @return The parallel minimum of the input values.
#' @note This function will always be faster than \code{pmin(x, a)} when \code{a} is a single value, but can be slower than \code{pmin.int(x, a)} when \code{x} is short. Use this function when comparing a numeric vector with a single value.
#' @export pminC
NULL

pminC <- function(x, a) {
    .Call(`_grattan_pminC`, x, a)
}

#' @title Parallel maximum
#' @description A faster \code{pmin()}.
#'
#' @name pminV
#' @param x A numeric vector.
#' @param y A numeric vector, the same length as x.
#' @return The parallel maximum of the input values.
#' @export pminV
NULL

pminV <- function(x, y) {
    .Call(`_grattan_pminV`, x, y)
}

#' @title SAPTO in C++
#' @description An implementation of SAPTO in C++.
#' @name sapto_rcpp
#' @param RebateIncome,MaxOffset,LowerThreshold,TaperRate,SaptoEligible,SpouseIncome,IsMarried As in \code{\link{sapto}}.
#' @export
sapto_rcpp <- function(RebateIncome, MaxOffset, LowerThreshold, TaperRate, SaptoEligible, SpouseIncome, IsMarried) {
    .Call(`_grattan_sapto_rcpp`, RebateIncome, MaxOffset, LowerThreshold, TaperRate, SaptoEligible, SpouseIncome, IsMarried)
}

#' SAPTO singleton
#' @name sapto_rcpp_singleton
#' @description Length-one version of \code{SAPTO} in C++.
#' @param rebate_income,max_offset,lower_threshold,taper_rate,sapto_eligible,Spouse_income,is_married As in \code{\link{sapto}}.
#' @export
sapto_rcpp_singleton <- function(rebate_income, max_offset, lower_threshold, taper_rate, sapto_eligible, Spouse_income, is_married) {
    .Call(`_grattan_sapto_rcpp_singleton`, rebate_income, max_offset, lower_threshold, taper_rate, sapto_eligible, Spouse_income, is_married)
}

#' @title SAPTO for specific years in C++
#' @name sapto_rcpp_yr
#' @description Fast way to calculate SAPTO for multiple people when the year is known in advance. Speed is by cheating and entering in the year's parameters literally.
#' @param RebateIncome,IsMarried,SpouseIncome As in \code{\link{sapto}}.
#' @export sapto_rcpp_yr
NULL

sapto_rcpp_yr_singleton <- function(rebateIncome, isMarried, spouseIncome, yr) {
    .Call(`_grattan_sapto_rcpp_yr_singleton`, rebateIncome, isMarried, spouseIncome, yr)
}

sapto_rcpp_yr <- function(RebateIncome, SpouseIncome, IsMarried, yr) {
    .Call(`_grattan_sapto_rcpp_yr`, RebateIncome, SpouseIncome, IsMarried, yr)
}

