% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/nested-functions.R
\name{nested_partial_residuals}
\alias{nested_partial_residuals}
\title{Partial residuals in nested form}
\usage{
nested_partial_residuals(object, terms = NULL, data = NULL)
}
\arguments{
\item{object}{a fitted GAM model}

\item{terms}{a vector of terms to include partial residuals for. Passed to
argument \code{terms} of \code{\link[mgcv:predict.gam]{mgcv::predict.gam()}}].}

\item{data}{optional data frame}
}
\value{
A nested tibble (data frame) with one row per smooth term. Contains
two columns:
\itemize{
\item \code{smooth} - a label indicating the smooth term
\item \code{partial_residual} - a list column containing a tibble (data frame) with
1 column \code{partial_residual} containing the requested partial residuals
for the indicated smooth.
}
}
\description{
Computes partial residuals for smooth terms, formats them in long/tidy
format, then nests the \code{partial_residual} column such that the result
is a nested data frame with one row per smooth.
}
\keyword{internal}
