% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/posterior-samples.R
\name{posterior_samples}
\alias{posterior_samples}
\alias{posterior_samples.gam}
\title{Draw samples from the posterior distribution of an estimated model}
\usage{
posterior_samples(model, ...)

\method{posterior_samples}{gam}(
  model,
  n,
  data = newdata,
  seed,
  scale = c("response", "linear_predictor"),
  freq = FALSE,
  unconditional = FALSE,
  weights = NULL,
  ncores = 1L,
  ...,
  newdata = NULL
)
}
\arguments{
\item{model}{a fitted model of the supported types}

\item{...}{arguments passed to other methods. For \code{fitted_samples()}, these
are passed on to \code{predict.gam()}.}

\item{n}{numeric; the number of posterior samples to return.}

\item{data}{data frame; new observations at which the posterior draws
from the model should be evaluated. If not supplied, the data used to fit
the model will be used for \code{data}, if available in \code{model}.}

\item{seed}{numeric; a random seed for the simulations.}

\item{scale}{character;}

\item{freq}{logical; \code{TRUE} to use the frequentist covariance matrix of
the parameter estimators, \code{FALSE} to use the Bayesian posterior
covariance matrix of the parameters.}

\item{unconditional}{logical; if \code{TRUE} (and \code{freq == FALSE}) then the
Bayesian smoothing parameter uncertainty corrected covariance matrix is
used, if available.}

\item{weights}{numeric; a vector of prior weights. If \code{data} is null
then defaults to \code{object[["prior.weights"]]}, otherwise a vector of ones.}

\item{ncores}{number of cores for generating random variables from a
multivariate normal distribution. Passed to \code{\link[mvnfast:rmvn]{mvnfast::rmvn()}}.
Parallelization will take place only if OpenMP is supported (but appears
to work on Windows with current \code{R}).}

\item{newdata}{Deprecated: use \code{data} instead.}
}
\value{
A tibble (data frame) with 3 columns containing the posterior
predicted values in long format. The columns are
\itemize{
\item \code{row} (integer) the row of \code{data} that each posterior draw relates to,
\item \code{draw} (integer) an index, in range \code{1:n}, indicating which draw each row
relates to,
\item \code{response} (numeric) the predicted response for the indicated row of
\code{data}.
}
}
\description{
Draw samples from the posterior distribution of an estimated model
}
\author{
Gavin L. Simpson
}
