% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/add-methods.R
\name{add_fitted.gam}
\alias{add_fitted.gam}
\title{Add fitted values from a GAM to a data frame}
\usage{
\method{add_fitted}{gam}(data, model, value = ".value", type = "response", prefix = ".", ...)
}
\arguments{
\item{data}{a data frame containing values for the variables used to fit the
model. Passed to \code{\link[stats:predict]{stats::predict()}} as \code{newdata}.}

\item{model}{a fitted model for which a \code{\link[stats:predict]{stats::predict()}} method is
available. S3 method dispatch is performed on the \code{model} argument.}

\item{value}{character; the name of the variable in which model predictions
will be stored.}

\item{type}{character; the type of predictions to return. See
\code{\link[mgcv:predict.gam]{mgcv::predict.gam()}} for options.}

\item{prefix}{character; string to prepend to names of predicted values when
\code{type} is \code{"terms"}, \code{"iterms"}, \code{"lpmatrix"}. These prediction types
result in a matrix of values being returned. \code{prefix} will be prepended to
each of the names of columns returned by such prediction types.}

\item{...}{additional arguments passed to \code{\link[mgcv:predict.gam]{mgcv::predict.gam()}}.}
}
\value{
A data frame (tibble) formed from \code{data} and predictions from
\code{model}.
}
\description{
Add fitted values from a GAM to a data frame
}
\examples{

load_mgcv()
\dontshow{
set.seed(1)
op <- options(digits = 3, cli.unicode = FALSE)
}
df <- gamSim(eg = 1, verbose = FALSE)
df <- df[, c("y","x0","x1","x2","x3")]
m <-  gam(y ~ s(x0) + s(x1) + s(x2) + s(x3), data = df, method = 'REML')

##
add_fitted(df, m)

## with type = "terms" or "iterms"
add_fitted(df, m, type = "terms")
\dontshow{options(op)}
}
