% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/as_yrqtr.R
\name{as_yrqtr}
\alias{as_yrqtr}
\alias{as_yrqtr.default}
\alias{as_yrqtr.yrqtr}
\alias{as_yrqtr.yrmon}
\alias{as_yrqtr.Date}
\alias{as_yrqtr.POSIXt}
\alias{as_yrqtr.character}
\alias{as_yrqtr.factor}
\title{Convert an object to a yrqtr}
\usage{
as_yrqtr(x, ...)

\method{as_yrqtr}{default}(x, ...)

\method{as_yrqtr}{yrqtr}(x, ...)

\method{as_yrqtr}{yrmon}(x, ...)

\method{as_yrqtr}{Date}(x, ...)

\method{as_yrqtr}{POSIXt}(x, ...)

\method{as_yrqtr}{character}(x, ...)

\method{as_yrqtr}{factor}(x, ...)
}
\arguments{
\item{x}{`An object to coerce to yrqtr.}

\item{...}{Not used.}
}
\value{
A \code{yrqtr} object.
}
\description{
\itemize{
\item Date, POSIXct, and POSIXlt are converted directly.  Any day, hour, minute,
or second components are dropped. POSIXct and POSIXlt are converted to
dates via \code{as.date()} with the timezone respected.
\item Character input is assumed to be provided in either ISO 8601 standard
format, i.e. "yyyy-mm-dd".
}
}
\note{
Internally \code{yrqtr} objects are stored as the number of quarters
(starting at 0) since the Unix Epoch (1970-01-01).
}
\examples{
as_yrqtr(Sys.Date())
as_yrqtr(as.POSIXct("2019-03-04 01:01:01", tz = "America/New_York"))
as_yrqtr("2019-05-03")

}
