% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/aaa_classes.R, R/graphpcor.R
\docType{class}
\name{graphpcor-class}
\alias{graphpcor-class}
\alias{graphpcor.formula}
\alias{graphpcor.matrix}
\alias{print.graphpcor}
\alias{summary.graphpcor}
\alias{dim.graphpcor}
\alias{edges,graphpcor-method}
\alias{plot,graphpcor,ANY-method}
\alias{Laplacian.graphpcor}
\alias{chol,graphpcor-method}
\alias{vcov,graphpcor-method}
\alias{prec.graphpcor}
\title{Set a graph whose nodes and edges represent variables and
conditional distributions, respectively.}
\usage{
\method{graphpcor}{formula}(...)

\method{graphpcor}{matrix}(...)

\method{print}{graphpcor}(x, ...)

\method{summary}{graphpcor}(object, ...)

\method{dim}{graphpcor}(x, ...)

\S4method{edges}{graphpcor}(object, which, ...)

\S4method{plot}{graphpcor,ANY}(x, y, ...)

\method{Laplacian}{graphpcor}(graph)

\S4method{chol}{graphpcor}(x, ...)

\S4method{vcov}{graphpcor}(object, ...)

\method{prec}{graphpcor}(model, ...)
}
\arguments{
\item{...}{list of formula used to define the edges.}

\item{x}{a \code{graphpcor} object}

\item{object}{graphpcor object}

\item{which}{not used}

\item{y}{graphpcor}

\item{graph}{graphpcor object, see \code{\link{graphpcor}}.}

\item{model}{graphpcor model object}
}
\description{
Set a graph whose nodes and edges represent variables and
conditional distributions, respectively.
}
\details{
The terms in the formula do represent the nodes.
The \code{~} is taken as link.
}
\section{Methods (by generic)}{
\itemize{
\item \code{edges(graphpcor)}: Extract the edges of a \code{graphcor} to be used for plot

\item \code{plot(x = graphpcor, y = ANY)}: The plot method for \code{graphpcor}

\item \code{chol(graphpcor)}: Build the unite diagonal lower triangle matrix

\item \code{vcov(graphpcor)}: The \code{vcov} method for a \code{graphpcor}

}}
\section{Functions}{
\itemize{
\item \code{graphpcor(formula)}: A \code{graphpcor} is a graph where a node represents
a variable and an edge a conditional distribution.

\item \code{graphpcor(matrix)}: Build a \code{graphpcor} from a matrix

\item \code{print(graphpcor)}: The print method for \code{graphpcor}

\item \code{summary(graphpcor)}: The summary method for \code{graphpcor}

\item \code{dim(graphpcor)}: The dim method for \code{graphpcor}

\item \code{Laplacian(graphpcor)}: The Laplacian method for a \code{graphpcor}

\item \code{prec(graphpcor)}: The precision method for 'graphpcor'

}}
\examples{
g1 <- graphpcor(x ~ y, y ~ v, v ~ z, z ~ x)
g1
summary(g1)
plot(g1)
prec(g1)
}
