% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/layouts.R, R/stress_function.R
\name{layout_igraph_focus}
\alias{layout_igraph_focus}
\alias{focal_layout}
\alias{layout_with_focus}
\title{Focal layout}
\usage{
layout_igraph_focus(g, v, iter = 500, tol = 1e-04, circular)

layout_with_focus(g, v, iter = 500, tol = 1e-04)
}
\arguments{
\item{g}{igraph object}

\item{v}{focal node to be placed in the center}

\item{iter}{number of iterations}

\item{tol}{stopping criterion}

\item{circular}{not used}
}
\value{
coordinates to be used layouting a graph
}
\description{
puts a focal node in the center and arrange other nodes in concentric circles according to distances.
}
\details{
the layout_igraph_* function should not be used directly. It is only used as an argument for 'ggraph'.
}
\examples{
library(igraph)
library(ggraph)
g <- sample_gnp(10,0.4)
ggraph(g,layout = "focus",v = 1)+
  draw_circle(use = "focus", max.circle = max(distances(g,1)))+
  geom_edge_link()+
  geom_node_point(shape = 21,fill = "grey25",size = 5)+
  theme_graph()+
  coord_fixed()
}
\references{
Brandes, U., & Pich, C. (2011). More flexible radial layout. Journal of Graph Algorithms and Applications, 15(1), 157-173.
}
