% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/transformation_functions.R
\name{Gamma2Sigma}
\alias{Gamma2Sigma}
\title{Transformation of \eGamma matrix to \eSigma or \eSigmaK matrix}
\usage{
Gamma2Sigma(Gamma, k = NULL, full = FALSE)
}
\arguments{
\item{Gamma}{Numeric \dxd variogram matrix.}

\item{k}{\code{NULL} (default) or an integer between \code{1} and \code{d}.
Indicates which matrix \eSigma, or \eSigmaK
should be produced.}

\item{full}{Logical. If true, then the \code{k}th row and column in \eSigmaK
are included and the function returns a \dxd matrix.
By default, \code{full = FALSE}.}
}
\value{
Numeric \eSigmaK matrix of size \d1xd1 if
\code{full = FALSE}, and \eSigma of size \dxd if \code{full = TRUE}.
}
\description{
Transforms the \code{Gamma} matrix from the definition of a
Huesler--Reiss distribution to the corresponding
\eSigma or \eSigmaK matrix.
}
\details{
Every \dxd \code{Gamma} matrix in the definition of a
Huesler--Reiss distribution can be transformed into a
\d1xd1 \eSigmaK matrix,
for any \code{k} from \code{1} to \code{d}. The inverse of \eSigmaK
contains the graph structure corresponding to the Huesler--Reiss distribution
with parameter matrix \code{Gamma}. If \code{full = TRUE}, then \eSigmaK
is returned as a \dxd matrix with additional \code{k}th row and column
that contain zeros.
For details see \insertCite{eng2019;textual}{graphicalExtremes} and
\insertCite{hen2022;textual}{graphicalExtremes}.
}
\examples{
Gamma <- cbind(
  c(0, 1.5, 1.5, 2),
  c(1.5, 0, 2, 1.5),
  c(1.5, 2, 0, 1.5),
  c(2, 1.5, 1.5, 0)
)
Gamma2Sigma(Gamma, k = 1, full = FALSE)

}
\references{
\insertAllCited{}
}
\seealso{
Other MatrixTransformations: 
\code{\link{Gamma2Theta}()},
\code{\link{Gamma2graph}()},
\code{\link{Sigma2Gamma}()},
\code{\link{Theta2Gamma}()}
}
\concept{MatrixTransformations}
