% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get-multiple-routes.R
\name{gh_get_routes}
\alias{gh_get_routes}
\title{Get multiple routes}
\usage{
gh_get_routes(x, y, ..., callback = NULL)
}
\arguments{
\item{x}{A single start point as (lat, lon) pair}

\item{y}{A matrix or a data frame containing columns with latitudes and longitudes
that are used as endpoints. Needs (lat, lon) order.}

\item{...}{Parameters that are passed to \link{gh_get_route}.}

\item{callback}{A callback function that is applied to every calculated route.}
}
\description{
Internally it just calls \link{gh_get_route} sevaral times.
See also \link{gh_get_spt}.
}
\examples{
\dontrun{
start_point <- c(52.519772, 13.392334)

end_points <- rbind(
  c(52.564665, 13.42083),
  c(52.564456, 13.342724),
  c(52.489261, 13.324871),
  c(52.48738, 13.454647)
)

time_distance_table <- gh_get_routes(
  start_point, end_points, calc_points = FALSE,
  callback = gh_time_distance
  ) \%>\%
  dplyr::bind_rows()

routes_sf <- gh_get_routes(start_point, end_points, callback = gh_as_sf) \%>\%
  do.call(rbind, .)
}
}
