% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/matchBlocks.R
\name{permutParam}
\alias{permutParam}
\title{Permute block labels of a stochastic block model parameter}
\usage{
permutParam(theta, permut)
}
\arguments{
\item{theta}{a SBM parameter with say K blocks}

\item{permut}{a permutation of the block labels 1,2,...,K}
}
\value{
stochastic block model parameter with permuted block labels
}
\description{
Permute block labels of a stochastic block model parameter
}
\examples{
theta1 <- list(pi=c(.5,.5), gamma=matrix((1:4)/8,2,2))
theta2 <- list(pi=c(.5,.5), gamma=matrix(4:1/8,2,2))
permutParam(theta1, 2:1)
permutParam(theta2, 2:1)
}
