% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/g_percol.R
\name{g_percol}
\alias{g_percol}
\title{Prune a graph using the 'percolation threshold' method}
\usage{
g_percol(x, val_step = 20)
}
\arguments{
\item{x}{A symmetric \code{matrix} of pairwise distances between nodes}

\item{val_step}{The number of classes to create to search for the
threshold value without testing all the possibilities. By default,
'val_step = 20'.}
}
\value{
A graph object of type \code{igraph}
}
\description{
The function allows to prune a graph by removing
the links with the largest weights until the graph breaks into
two components. The returned graph is the last graph with only one
component.
}
\examples{
data(data_simul_genind)
suppressWarnings(mat_w <- graph4lg::mat_geo_dist(data=pts_pop_simul,
                            ID = "ID",
                            x = "x",
                            y = "y"))
g_percol(x = mat_w)
}
\author{
P. Savary
}
