% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/load.R
\name{ReadNewTotal}
\alias{ReadNewTotal}
\title{Read sparse new/total matrices}
\usage{
ReadNewTotal(
  genes,
  cells,
  new.matrix,
  total.matrix,
  detection.rate = 1,
  verbose = FALSE
)
}
\arguments{
\item{genes}{csv file (or URL) containing gene information}

\item{cells}{csv file (or URL) containing cell information}

\item{new.matrix}{Matrix market file of new counts}

\item{total.matrix}{Matrix market file of total counts}

\item{detection.rate}{the detection rate of T-to-C mismatch reads (see details)}

\item{verbose}{verbose output}
}
\value{
a grandR object
}
\description{
This function can be used to load matrix market data in case genes were quantified by
(i) counting all reads (for total RNA) and (ii) counting T-to-C mismatch reads (for new RNA)
}
\details{
Metabolic labeling - nucleotide conversion RNA-seq data (such as generated by SLAM-seq,TimeLapse-seq or TUC-seq)
must be carefully analyzed to remove bias due to incomplete labeling. We advice against counting read with and without T-to-C mismatches
for quantification, and encourage using a statistical method such as GRAND-SLAM that properly deals with incomplete labeling.

To correct for some bias, a detection rate (as suggested by Cao et al., Nature Biotech 2020) should be provided. This detection rate
defines, how much new RNA is detected on average using the T-to-C mismatch reads.
}
\concept{load}
