% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.R
\name{PlotHeatmap}
\alias{PlotHeatmap}
\title{Create heatmaps from grandR objects}
\usage{
PlotHeatmap(
  data,
  type = DefaultSlot(data),
  columns = NULL,
  genes = NULL,
  summarize = NULL,
  transform = "Z",
  cluster.genes = TRUE,
  cluster.columns = FALSE,
  label.genes = NULL,
  xlab = NULL,
  breaks = NULL,
  colors = NULL,
  title = NULL,
  return.matrix = FALSE,
  na.to = NA,
  ...
)
}
\arguments{
\item{data}{the grandR object that contains the data to plot}

\item{type}{Either a mode.slot (see details) or a regex to be matched against analysis names. Can also be a vector}

\item{columns}{a vector of columns (either condition/cell names if the type is a mode.slot, or names in the output table from an analysis; use \link{Columns}(data,<analysis>) to learn which columns are available); all condition/cell names if NULL}

\item{genes}{the genes to be included in the plot (default: all genes)}

\item{summarize}{Should replicates by summarized? Can only be specified if columns is NULL; either a summarization matrix (\link{GetSummarizeMatrix}) or TRUE (in which case \link{GetSummarizeMatrix}(data) is called)}

\item{transform}{apply a transformation to the selected data; can be a function, or a character (see details)}

\item{cluster.genes}{should genes be clustered?}

\item{cluster.columns}{should samples (or cells) be clustered?}

\item{label.genes}{should genes be labeled?}

\item{xlab}{The names to show at the x axis (only works if type is a single slot)}

\item{breaks}{vector of color breaks; can be NULL (see details)}

\item{colors}{an RColorBrewer palette name; can be NULL (see details)}

\item{title}{the title for the plot; can be NULL}

\item{return.matrix}{if TRUE, return a list containing the data matrix and the heatmap instead of the heatmap alone}

\item{na.to}{convert NA values in the matrix to this value immediately before computing the heatmap}

\item{...}{additional parameters forwarded to \link[ComplexHeatmap]{Heatmap}}
}
\value{
a ComplexHeatmap object
}
\description{
Convenience method to compare among more two variables (slot data or analyses results).
}
\details{
This is just a convenience function which
\enumerate{
\item{Calls \link{GetTable} with the parameter \code{type,columns,summarize,genes}}
\item{Transforms the returned table using the \code{transform} parameter}
\item{Determines reasonable colors using \code{breaks} and \code{colors}}
\item{and then calls ComplexHeatmap::Heatmap}
}

\code{type} and \code{columns} can refer to values from data slots values from analyses (and can be mixed).
If there are types from both data and analyses, columns must be NULL.
Otherwise columns must either be condition/cell names (if type refers to one or several data slots), or regular expressions
to match against the names in the analysis tables.

Columns definitions for data slots can be given as a logical, integer or character vector representing a selection of the columns (samples or cells).
The expression is evaluated in an environment having the \code{\link{Coldata}}, i.e. you can use names of \code{\link{Coldata}} as variables to
conveniently build a logical vector (e.g., columns=Condition=="x").

To refer to data slots, the mode.slot syntax can be used: Each name is either a data slot, or one of (new,old,total)
followed by a dot followed by a slot. For new or old, the data slot value is multiplied by ntr or 1-ntr. This can be used e.g. to obtain the \emph{new counts}.

The transform parameter either is a function that transforms a matrix (which can conveniently be done using the Transform.XXX functions described next), or
a character (which must be the XXX to find such a function). Available data transformations are
\itemize{
 \item{transform=Transform.Z() or transform="Z": compute z scores for each row (see \link{Transform.Z})}
 \item{transform=Transform.VST() or transform="VST": do a variance stabilizing transformation (see \link{Transform.VST})}
 \item{transform=Transform.logFC() or transform="logFC": compute log2 fold changes to one or several reference columns; which must be defined via parameters (see \link{Transform.logFC})}
 \item{transform=Transform.no() or transform="no": do not transform (see \link{Transform.no})}
}

Reasonable coloring is chosen depending on the value distribution in the matrix. If the values are zero centered (e.g. z scores or most often log fold changes), then
by default the 50% and 95% quantiles of all positive and all negative values are determined. Let q95 be the 95% quantile with the larger absolute value, and q50 likewise the 50%
quantile with the larger value. The breaks are -q90,q50,0,q50,q90, and, by default, the red to blue "RdBu" palette from RColorBrewer is taken. If the values are not zero centered,
the 5%,25%,50%,75%, and 95% quantiles are used as breaks and the yellow-orange-red ("YlOrRd") palette is taken. Breaks can also be specified (as absolute values).

xlab can be given as a character vector or an expression that evaluates into a character vector.
The expression is evaluated in an environment having the \code{\link{Coldata}}, i.e. you can use names of \code{\link{Coldata}} as variables.
}
\seealso{
\link{GetTable},\link[ComplexHeatmap]{Heatmap}
}
\concept{globalplot}
