% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{structure2vector}
\alias{structure2vector}
\alias{kinetics2vector}
\title{Convert a structure into a vector}
\usage{
structure2vector(d, return.fields = NULL, return.extra = NULL)

kinetics2vector(
  d,
  condition = NULL,
  return.fields = c("Synthesis", "Half-life"),
  return.extra = NULL
)
}
\arguments{
\item{d}{the data structure}

\item{return.fields}{which fields should be extracted directly (may be NULL)}

\item{return.extra}{apply a function returning a flat list or vector (may be NULL)}

\item{condition}{if the original grandR object had \code{\link{Condition}} set, which condition to extract (NULL otherwise)}
}
\value{
the data flattened into a vector
}
\description{
The structure is supposed to be a list. Flattening is done by extracting the given fields (\code{return.fields})
and applying the additional function (\code{return.extra}). This is mainly to be used within \code{sapply} and similar.
}
\section{Functions}{
\itemize{
\item \code{kinetics2vector()}: Convert the output of the FitKinetics methods into a vector

}}
\examples{
sars <- ReadGRAND(system.file("extdata", "sars.tsv.gz", package = "grandR"),
                  design=c("Condition",Design$dur.4sU,Design$Replicate))
sars <- Normalize(sars)
fit <- FitKineticsGeneLeastSquares(sars,"SRSF6")$Mock
print(fit)
kinetics2vector(fit)

}
\concept{helper}
