% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dropout.R
\name{dropout}
\alias{dropout}
\alias{Plot4sUDropoutRankAll}
\alias{Plot4sUDropoutAll}
\alias{Plot4sUDropoutDeferAll}
\alias{Plot4sUDropoutRankDeferAll}
\alias{Plot4sUDropoutRank}
\alias{Plot4sUDropout}
\title{Perform 4sU dropout tests}
\usage{
Plot4sUDropoutRankAll(data, pairs = Findno4sUPairs(data), ...)

Plot4sUDropoutAll(data, pairs = Findno4sUPairs(data), ...)

Plot4sUDropoutDeferAll(data, pairs = NULL, ...)

Plot4sUDropoutRankDeferAll(data, pairs = NULL, ...)

Plot4sUDropoutRank(
  data,
  w4sU,
  no4sU = Findno4sUPairs(data)[[w4sU]],
  ntr = w4sU,
  ylim = NULL,
  LFC.fun = lfc::PsiLFC,
  slot = "count",
  correction = 1,
  label.corr = TRUE,
  return.corr = FALSE,
  boxplot.bins = 10,
  title = w4sU,
  size = 1.5
)

Plot4sUDropout(
  data,
  w4sU,
  no4sU = Findno4sUPairs(data)[[w4sU]],
  ntr = w4sU,
  ylim = NULL,
  LFC.fun = lfc::PsiLFC,
  slot = "count",
  hl.quantile = 0.8,
  hl = NULL,
  correction = 1,
  title = w4sU,
  size = 1.5
)
}
\arguments{
\item{data}{a grandR object}

\item{pairs}{a no4sU pairs list as generated by \link{Findno4sUPairs}}

\item{...}{further arguments to be passed to or from other methods.}

\item{w4sU}{the name of a 4sU sample}

\item{no4sU}{the name(s) of equivalent no4sU sample(s)}

\item{ntr}{the name of a sample to take NTRs from (usually equal to w4sU)}

\item{ylim}{y axis limits}

\item{LFC.fun}{function to compute log fold change (default: \link[lfc]{PsiLFC}, other viable option: \link[lfc]{NormLFC})}

\item{slot}{the slot of the grandR object to take the data from; for \link[lfc]{PsiLFC}, this really should be "count"!}

\item{correction}{correction factor}

\item{label.corr}{add statistics as subtitle}

\item{return.corr}{instead of only the ggplot object, return a list with slots plot (what is normally returned) and label (the correlation statistics)}

\item{boxplot.bins}{how many boxplots for \code{Plot4sUDropoutRank}}

\item{title}{the main title for the plot}

\item{size}{the point size}

\item{hl.quantile}{the half-life quantile to cut the plot}

\item{hl}{if NULL, compute half-lives from the ntr column; otherwise, must be a vector containing half-lives}
}
\value{
either a ggplot object, a list of ggplot objects, or a list of deferred functions for plotting
}
\description{
Testing for RNA dropout of a 4sU sample is performed by comparing half-lives or NTR ranks against
the log2 fold change of the 4sU sample vs equivalent no4sU samples.
}
\details{
The deferred versions are useful to be used in conjunction with \link{ServeGrandR} plot.static. Their implementation
make sure that they are lightweight, i.e. when saving the returned function to an Rdata file, the grandR object is not stored.
}
\seealso{
\link{Findno4sUPairs},\link{Defer}
}
\concept{dropout}
