% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/diagnostics.R
\name{PlotMismatchPositionForSample}
\alias{PlotMismatchPositionForSample}
\title{Diagnostic plot for mismatch position for columns (by sample)}
\usage{
PlotMismatchPositionForSample(
  data,
  sample,
  orientation = NULL,
  category = NULL
)
}
\arguments{
\item{data}{a grandR object}

\item{sample}{a sample name}

\item{orientation}{restrict to either Sense or Antisense; can be NULL}

\item{category}{restrict to a specific category (see \link{GetDiagnosticParameters}); can be NULL}
}
\value{
a list with a ggplot object, a description, and the desired size for the plot
}
\description{
This belongs to the first diagnostic plots (raw mismatches) generated by GRAND3.
}
\details{
For all positions along the reads (x axis; potentially paired end, shown left and right),
show the percentage of all mismatch types. The panel in column T and row C shows T-to-C mismatches.
Positions outside of shaded areas are clipped. Uncorrected and Retained means before and
after correcting multiply sequenced bases. Sense/Antisense means reads (first read for paired end)
that are (based on the annotation) oriented in sense or antisense direction to a gene
(i.e. this is only relevant for sequencing protocols that do not preserve strand information).
}
\concept{diagnostics}
