% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/grand.table.R
\name{grand.table}
\alias{grand.table}
\title{Generate a Guidelines for Reporting About Network Data (GRAND) summary table}
\usage{
grand.table(G, digits = 3)
}
\arguments{
\item{G}{An \code{\link{igraph}} object with GRAND attributed}

\item{digits}{numeric: number of decimal places to report}
}
\value{
A plot
}
\description{
The \code{grand.table} function plots a tabular summary of GRAND attributes that were
added to an \code{igraph} object using \code{\link[=grand]{grand()}}.
}
\examples{
#A weighted, directed network
data(airport)  #Load example data
grand.table(airport)  #Generate narrative

#A bipartite network
data(cosponsor)  #Load example data
grand.table(cosponsor)  #Generate narrative

#A signed network
data(senate)  #Load example data
grand.table(senate)  #Generate narrative
}
