% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_befafter_box.R
\name{plot_befafter_box}
\alias{plot_befafter_box}
\title{Before-after style graph with a boxplot}
\usage{
plot_befafter_box(
  data,
  xcol,
  ycol,
  match,
  facet,
  PlotShapes = FALSE,
  symsize = 3,
  s_alpha = 0.8,
  b_alpha = 1,
  bwid = 0.4,
  jitter = 0.1,
  TextXAngle = 0,
  LogYTrans,
  LogYBreaks = waiver(),
  LogYLabels = waiver(),
  LogYLimits = NULL,
  facet_scales = "fixed",
  fontsize = 20,
  symthick,
  bthick,
  lthick,
  ColPal = c("okabe_ito", "all_grafify", "bright", "contrast", "dark", "fishy", "kelly",
    "light", "muted", "pale", "r4", "safe", "vibrant"),
  ColSeq = TRUE,
  ColRev = FALSE,
  SingleColour = "NULL",
  ...
)
}
\arguments{
\item{data}{a data table object, e.g. data.frame or tibble.}

\item{xcol}{name of the column containing the categorical variable to be plotted on the X axis.}

\item{ycol}{name of the column containing the quantitative Y values.}

\item{match}{name of the column with the grouping variable to pass on to \code{geom_line}.}

\item{facet}{add another variable from the data table to create faceted graphs using \code{ggplot2}\link{facet_wrap}.}

\item{PlotShapes}{logical TRUE or FALSE (default = FALSE) if the shape of the symbol is to be mapped to the \code{match} variable. Note that only 25 shapes allowed.}

\item{symsize}{size of symbols, default set to 3.}

\item{s_alpha}{fractional opacity of symbols, default set to 0.8 (i.e., 80\% opacity).}

\item{b_alpha}{fractional opacity of boxes, default set to 1.}

\item{bwid}{width of boxplots; default 0.4.}

\item{jitter}{extent of jitter (scatter) of symbols, default is 0.1. Increase to reduce symbol overlap, set to 0 for aligned symbols.}

\item{TextXAngle}{orientation of text on X-axis; default 0 degrees. Change to 45 or 90 to remove overlapping text.}

\item{LogYTrans}{transform Y axis into "log10" or "log2"}

\item{LogYBreaks}{argument for \code{ggplot2[scale_y_continuous]} for Y axis breaks on log scales, default is \code{waiver()}, or provide a vector of desired breaks.}

\item{LogYLabels}{argument for \code{ggplot2[scale_y_continuous]} for Y axis labels on log scales, default is \code{waiver()}, or provide a vector of desired labels.}

\item{LogYLimits}{a vector of length two specifying the range (minimum and maximum) of the Y axis.}

\item{facet_scales}{whether or not to fix scales on X & Y axes for all facet facet graphs. Can be \code{fixed} (default), \code{free}, \code{free_y} or \code{free_x} (for Y and X axis one at a time, respectively).}

\item{fontsize}{parameter of \code{base_size} of fonts in \code{theme_classic}, default set to size 20.}

\item{symthick}{size (in 'pt' units) of outline of symbol lines (\code{stroke}), default = \code{fontsize}/22.}

\item{bthick}{thickness (in 'pt' units) of boxes; default = \code{(fontsize)/22}.}

\item{lthick}{thickness (in 'pt' units) of lines; default = \code{(fontsize/1.2)/22}.}

\item{ColPal}{grafify colour palette to apply, default "okabe_ito"; see \code{\link{graf_palettes}} for available palettes.}

\item{ColSeq}{logical TRUE or FALSE. Default TRUE for sequential colours from chosen palette. Set to FALSE for distant colours, which will be applied using  \code{scale_fill_grafify2}.}

\item{ColRev}{whether to reverse order of colour within the selected palette, default F (FALSE); can be set to T (TRUE).}

\item{SingleColour}{a colour hexcode (starting with #), a number between 1-154, or names of colours from \code{grafify} or base R palettes to fill along X-axis aesthetic. Accepts any colour other than "black"; use \code{grey_lin11}, which is almost black.}

\item{...}{any additional arguments to pass to \code{ggplot2}\link{geom_line},  \code{ggplot2}\link{geom_point}, or \code{ggplot2}\link{facet_wrap}.}
}
\value{
This function returns a \code{ggplot2} object of class "gg" and "ggplot".
}
\description{
The \code{\link{plot_befafter_box}}, \code{\link{plot_befafter_colours}}, \code{\link{plot_befafter_colors}} and \code{\link{plot_befafter_shapes}} are for plotting matched data joined by lines. These functions take X and Y variables along with a data column with matching information (e.g. matched subjects or experiments etc.) and plot symbols matched by colour or shape.
}
\details{
Use \code{\link{plot_befafter_box}} to also get a boxplot with matched data. In this function, the categorical variable along X axis is mapped to the fill-colour aesthetic.

The default is a plot without matching shapes. Change the \code{PlotShapes} argument to \code{TRUE} for plot similar to \code{\link{plot_befafter_shapes}}. Note that with \code{PlotShapes = TRUE} the colour of symbols will always be black and the X-axis variable is mapped to the fill colour of boxplots.

Note that only 25 shapes are available, and there will be errors with \code{\link{plot_befafter_shapes}} when there are fewer than 25 matched observations; instead use default (\code{PlotShapes = FALSE}).

Add another variable to make faceted graphs with the \code{facet} argument.

Colours can be changed using \code{ColPal}, \code{ColRev} or \code{ColSeq} arguments.
\code{ColPal} can be one of the following: "okabe_ito", "dark", "light", "bright", "pale", "vibrant,  "muted" or "contrast".
\code{ColRev} (logical TRUE/FALSE) decides whether colours are chosen from first-to-last or last-to-first from within the chosen palette.
\code{ColSeq} decides whether colours are picked by respecting the order in the palette or the most distant ones using \code{\link[grDevices]{colorRampPalette}}.

To plot a graph with a single colour along the X axis variable, use the \code{SingleColour} argument.
}
\examples{
#plot without legends if necessary
plot_befafter_box(data = data_t_pdiff, 
xcol = Condition, ycol = Mass, 
match = Subject)
#with PlotShapes = TRUE
plot_befafter_box(data = data_t_pdiff, 
xcol = Condition, ycol = Mass, 
match = Subject, PlotShapes = TRUE)
#2way ANOVA design with randomised blocks
plot_befafter_box(data = data_2w_Tdeath, 
xcol = Time2, ycol = PI, 
match = Experiment, facet = Genotype)

}
